<?php

/*
 *
 * File ini bagian dari:
 *
 * OpenSID
 *
 * Sistem informasi desa sumber terbuka untuk memajukan desa
 *
 * Aplikasi dan source code ini dirilis berdasarkan lisensi GPL V3
 *
 * Hak Cipta 2009 - 2015 Combine Resource Institution (http://lumbungkomunitas.net/)
 * Hak Cipta 2016 - 2025 Perkumpulan Desa Digital Terbuka (https://opendesa.id)
 *
 * Dengan ini diberikan izin, secara gratis, kepada siapa pun yang mendapatkan salinan
 * dari perangkat lunak ini dan file dokumentasi terkait ("Aplikasi Ini"), untuk diperlakukan
 * tanpa batasan, termasuk hak untuk menggunakan, menyalin, mengubah dan/atau mendistribusikan,
 * asal tunduk pada syarat berikut:
 *
 * Pemberitahuan hak cipta di atas dan pemberitahuan izin ini harus disertakan dalam
 * setiap salinan atau bagian penting Aplikasi Ini. Barang siapa yang menghapus atau menghilangkan
 * pemberitahuan ini melanggar ketentuan lisensi Aplikasi Ini.
 *
 * PERANGKAT LUNAK INI DISEDIAKAN "SEBAGAIMANA ADANYA", TANPA JAMINAN APA PUN, BAIK TERSURAT MAUPUN
 * TERSIRAT. PENULIS ATAU PEMEGANG HAK CIPTA SAMA SEKALI TIDAK BERTANGGUNG JAWAB ATAS KLAIM, KERUSAKAN ATAU
 * KEWAJIBAN APAPUN ATAS PENGGUNAAN ATAU LAINNYA TERKAIT APLIKASI INI.
 *
 * @package   OpenSID
 * @author    Tim Pengembang OpenDesa
 * @copyright Hak Cipta 2009 - 2015 Combine Resource Institution (http://lumbungkomunitas.net/)
 * @copyright Hak Cipta 2016 - 2025 Perkumpulan Desa Digital Terbuka (https://opendesa.id)
 * @license   http://www.gnu.org/licenses/gpl.html GPL V3
 * @link      https://github.com/OpenSID/OpenSID
 *
 */

namespace App\Http\Transformers;

use App\Models\Pembangunan;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;
use League\Fractal\TransformerAbstract;

class PembangunanTransformer extends TransformerAbstract
{
    public function transform(Pembangunan $pembangunan)
    {
        $pembangunan->foto = $this->urlAsset($pembangunan->foto);
        $pembangunan->lokasi ??= $pembangunan->lokasi_lengkap;

        $pembangunan->pembangunan_dokumentasi = $pembangunan->pembangunanDokumentasi->map(
            fn ($dokumentasi) => $dokumentasi->setAttribute('gambar', $this->urlAsset($dokumentasi->gambar))
        );

        return $pembangunan->toArray();
    }

    private function urlAsset(?string $foto = '')
    {
        return URL::signedRoute('storage.desa', [
            'path'        => (string) Str::of(LOKASI_GALERI)->remove('desa/')->append($foto),
            'default'     => 'images/404-image-not-found.jpg',
            'defaultDisk' => 'assets',
        ]);
    }
}
