tinymce.PluginManager.add('laporan_keuangan', function (editor, url) {
	editor.ui.registry.addMenuButton('laporan_keuangan', {
		text: 'Laporan Keuangan',
		fetch: function (callback) {
			var items = [
				{
					type: 'menuitem',
					text: 'Tabel Laporan',
					icon: 'table',
					onAction: function () {
						var url = BASE_URL + "/keuangan_manual/cek_tahun_manual";

						$.ajax({
							type: "GET",
							url: url,
							dataType: "json",
							success: function (data) {
								editor.windowManager.open({
									title: 'Tahun Anggaran',
									body: {
										type: 'panel',
										items: [
											{
												type: 'selectbox',
												name: 'tahun',
												label: 'Pilih Tahun Anggaran',
												items: data
											},
										]
									},
									buttons: [
										{ type: 'cancel', text: 'Tutup' },
										{ type: 'submit', text: 'Pilih', primary: true }
									],
									onSubmit: function (api) {
										var data = api.getData();
										editor.insertContent('[[lap-RP-APBD,' + data.tahun + ']]');
										api.close();
									},
									width: 400,
									height: 140
								})
							},
							error: function (xhr, status, error) {
								alert("Error! " + xhr.status + "\n" + error);
								console.log(xhr);
							}
						});
					}
				},
				{
					type: 'menuitem',
					text: 'Grafik Laporan',
					icon: 'align-left',
					onAction: function () {
						var url = BASE_URL + "/keuangan_manual/cek_tahun_manual";

						$.ajax({
							type: "GET",
							url: url,
							dataType: "json",
							success: function (data) {
								editor.windowManager.open({
									title: 'Tahun Anggaran',
									body: {
										type: 'panel',
										items: [
											{
												type: 'selectbox',
												name: 'tahun',
												label: 'Pilih Tahun Anggaran',
												items: data
											},
										]
									},
									buttons: [
										{ type: 'cancel', text: 'Tutup' },
										{ type: 'submit', text: 'Pilih', primary: true }
									],
									onSubmit: function (api) {
										var data = api.getData();
										editor.insertContent('[[grafik-RP-APBD,' + data.tahun + ']]');
										api.close();
									},
									width: 400,
									height: 140
								})
							},
							error: function (xhr, status, error) {
								alert("Error! " + xhr.status + "\n" + error);
								console.log(xhr);
							}
						});
					}
				},
			];
			callback(items);
		},
	});
});
